/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.api.projector.IProjectorRenderInfo;
import dev.compactmods.crafting.client.ClientConfig;
import dev.compactmods.crafting.client.render.CCRenderTypes;
import dev.compactmods.crafting.client.render.GhostRenderer;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.ProjectorHelper;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ClientProjectorRenderInfo
implements IProjectorRenderInfo {
    private final BlockState baseState;
    private final HashMap<BlockPos, Direction> remainingProjectors = new HashMap(4);
    private int renderTime;

    public ClientProjectorRenderInfo() {
        this.baseState = ((Block)CCBlocks.FIELD_PROJECTOR_BLOCK.get()).m_49966_();
    }

    @Override
    public Set<BlockPos> getMissingProjectors() {
        return this.remainingProjectors.keySet();
    }

    @Override
    public int getRenderTimeLeft() {
        return this.renderTime;
    }

    @Override
    public void render(PoseStack matrixStack) {
        if (this.renderTime == 0) {
            return;
        }
        if (this.remainingProjectors.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        Camera mainCamera = mc.f_91063_.m_109153_();
        ClientLevel level = mc.f_91073_;
        if (mc.f_91066_.f_92115_ == GraphicsStatus.FABULOUS) {
            this.render(matrixStack, buffers, mainCamera, level);
        } else {
            this.render(matrixStack, buffers, mainCamera, level);
        }
    }

    private void render(PoseStack matrixStack, MultiBufferSource.BufferSource buffers, Camera mainCamera, ClientLevel level) {
        matrixStack.m_85836_();
        Vec3 projectedView = mainCamera.m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        for (BlockPos pos : this.remainingProjectors.keySet()) {
            BlockPos realPos;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.m_123341_() + 0.05, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.05);
            matrixStack.m_85841_(0.9f, 0.9f, 0.9f);
            GhostRenderer.renderTransparentBlock((BlockState)this.baseState.m_61124_((Property)FieldProjectorBlock.FACING, (Comparable)this.remainingProjectors.get(pos)), pos, matrixStack, (MultiBufferSource)buffers, this.renderTime);
            matrixStack.m_85849_();
            for (int y = -1; y > -10 && level.m_7433_(realPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + y, pos.m_123343_()), BlockBehaviour.BlockStateBase::m_60795_); --y) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)pos.m_123341_() + 0.15, (double)pos.m_123342_() + 0.15 + (double)y, (double)pos.m_123343_() + 0.15);
                matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
                GhostRenderer.renderTransparentBlock(Blocks.f_50215_.m_49966_(), realPos, matrixStack, (MultiBufferSource)buffers, this.renderTime);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        RenderSystem.m_69465_();
        buffers.m_109912_(CCRenderTypes.PHANTOM);
    }

    @Override
    public void tick() {
        if (this.renderTime > 0) {
            --this.renderTime;
        }
        if (this.renderTime < 0) {
            this.renderTime = 0;
        }
    }

    @Override
    public void resetRenderTime() {
        this.renderTime = ClientConfig.placementTime;
    }

    @Override
    public void setProjector(Level level, BlockPos initial) {
        this.remainingProjectors.clear();
        Direction initialFacing = FieldProjectorBlock.getDirection((BlockGetter)level, initial).orElse(Direction.UP);
        Optional<MiniaturizationFieldSize> fieldSize = ProjectorHelper.getClosestSize((BlockGetter)level, initial, initialFacing);
        if (fieldSize.isPresent()) {
            BlockPos center = fieldSize.get().getCenterFromProjector(initial, initialFacing);
            Direction.Plane.HORIZONTAL.m_122557_().forEach(dir -> {
                if (dir.m_122424_() == initialFacing) {
                    return;
                }
                BlockPos location = ((MiniaturizationFieldSize)((Object)((Object)fieldSize.get()))).getProjectorLocationForDirection(center, (Direction)dir);
                if (!(level.m_8055_(location).m_60734_() instanceof FieldProjectorBlock)) {
                    this.remainingProjectors.put(location, dir.m_122424_());
                }
            });
        } else {
            ProjectorHelper.getValidOppositePositions(initial, initialFacing).forEach(pos -> this.remainingProjectors.put((BlockPos)pos, initialFacing.m_122424_()));
        }
    }
}

